<?php
/*
* Plugin Name:       LosArcanos Horoscopo
* Plugin URI:        https://www.losarcanos.com/plugins/
* Description:       Horoscopo de LosArcanos.com
* Author:            Luis Reynoso
* Version:           1.1.2
* Requires at least: 5.2
* Requires PHP:      7.2
* Author URI:        https://www.losarcanos.com/
* License:           GPL v2 or later
* License URI:       https://www.gnu.org/licenses/gpl-2.0.html
* Update URI:        https://www.losarcanos.com/plugins/
*/


// Variable Global
$horo_ext = array();

// busca el horosocopo
function lalwr_mostrarlahoro($atts = [], $content = null, $tag = '' ) {


    global $horo_ext;

    $atts = array_change_key_case( (array) $atts, CASE_LOWER );

    $args = shortcode_atts1( 
        array(
            'texto'   => 'general',
            'signo'   => 'aries',
        ), 
        $atts
    );

    $signo = strtolower(esc_attr(sanitize_text_field( $args['signo'] )));
    $texto = strtolower(esc_attr(sanitize_text_field( $args['texto'] )));    

    $mensaje = '';

    $asignos = array("aries","tauro","geminis","cancer","leo","virgo","libra","escorpio","sagitario","capricornio","acuario","piscis");
    $signospt = array("carneiro","touro","gémeos","carangueijo","leão","vírgem","balança","escorpião","sagitário","capricórnio","aquário","peixes");
    $signosen = array("aries","taurus","gemini","cancer","leo","virgo","libra","scorpio","sagittarius","capricorn","aquarius","pisces");


    $ind = array_search($signo, $signosen);

  
    if ($ind !==false) {
        $signo = $asignos[$ind];
    }

    $ind = array_search($signo, $signospt);
    if ($ind !==false) {
        $signo = $asignos[$ind];
    }  
 

    $arraywords = array('Trabajo','Amor','Salud','Horóscopo','Horóscopo Semanal LosArcanos.com','https://www.losarcanos.com/horoscopo.php');
    if (substr(get_locale(),0,2) == 'en') {
        $arraywords = array('Work Horoscope','Love Horoscope','Health Horoscope','Horoscope','Weekly Horoscope LosArcanos.com','https://www.losarcanos.com/en/horoscope.php');
    }
    if (substr(get_locale(),0,2) == 'pt') {
        $arraywords = array('horóscopo de trabalho','horóscopo do amor','horóscopo da saúde','Horóscopo','Horóscopo Semanal LosArcanos.com','https://www.losarcanos.com/horoscopo-pt.php');
    }    

    

    if (in_array($signo, $asignos)) {

        if (empty($horo_ext)) {

            $siteurl = base64_encode(get_option('siteurl') . $_SERVER['REQUEST_URI']);

            $locale = base64_encode(get_locale());

            $getarc = 'https://www.losarcanos.com/wp-remote/horoscopowp.php?l=' . $locale . '&u=' . $siteurl;

            $response = wp_remote_get($getarc);
            $http_code = wp_remote_retrieve_response_code( $response );
            if ($http_code = 200) {
                $body = wp_remote_retrieve_body( $response );
                $horo_ext = json_decode($body, true);
                //echo 'Cargando...';

            } else {
                $mensaje = 'Error en conexion!';
            }
        }

        if ($texto == 'fecha') {
            $mensaje = '<h3>'. esc_html($horo_ext['fecha']) . '</h3>';
        }
        if ($texto == 'titulo') {
            $mensaje = '<h2>'. esc_html($horo_ext[$signo . '-titulo']). '</h2>';
        }
        if ($texto == 'general') {
            $mensaje = '<p>'. esc_html($horo_ext[$signo . '-texto'])  . ' <br><a href="' . $arraywords[5] . '" style="font-size:14px">' . $arraywords[4] . '</a></p>';
        }            
        if ($texto == 'trabajo') {
            $mensaje = '<p>'. esc_html($horo_ext[$signo . '-trabajo']) . '</p>';
        }   
        if ($texto == 'amor') {
            $mensaje = '<p>'. esc_html($horo_ext[$signo . '-amor']) . '</p>';
        }   
        if ($texto == 'salud') {
            $mensaje = '<p>'. esc_html($horo_ext[$signo . '-salud']) . '</p>';
        }               
        if ($texto == 'imagen') {
            $mensaje = '<center><img src="'. esc_html($horo_ext[$signo . '-imagen']) . '" alt="Girl in a jacket" width="500" height="500" style="border-radius: 50%"></center>';
        }       
        
        if ($texto == 'todo') {

            $mensaje = '<h2 style="text-align:center">'. $arraywords[3] . '<br>'. esc_html($horo_ext['fecha'])  . '</h2>';

            foreach ($asignos as &$szod) {
                $mensaje .= '<h3 style="text-align:center">'. esc_html($horo_ext[$szod . '-titulo']). '</h3>';
                $mensaje .= '<center><img src="'. esc_html($horo_ext[$szod . '-imagen']) . '" alt="Girl in a jacket" width="500" height="500" style="border-radius: 50%"></center>';
                $mensaje .= '<p>'. esc_html($horo_ext[$szod . '-texto'])  . '</p>';
                $mensaje .= '<h3 style="text-align:center">'. ucfirst($szod) . ' ' . $arraywords[0] . '</h3>';
                $mensaje .= '<p>'. esc_html($horo_ext[$szod . '-trabajo']) . '</p>';
                $mensaje .= '<h3 style="text-align:center">'. ucfirst($szod) . ' ' . $arraywords[1] . '</h3>';
                $mensaje .= '<p>'. esc_html($horo_ext[$szod . '-amor']) . '</p>';
                $mensaje .= '<h3 style="text-align:center">'. ucfirst($szod) . ' ' . $arraywords[2] . '</h3>';
                $mensaje .= '<p>'. esc_html($horo_ext[$szod . '-salud']) . '</p>';
            }    

            $mensaje .= '<p style="text-align:center" ><a href="' . $arraywords[5] . '" style="font-size:16px">' . $arraywords[4] . '</a></p>';

        }

        if ($texto == 'signotodo') {

            $mensaje = '<h2 style="text-align:center">'. $arraywords[3] . '<br>'. esc_html($horo_ext['fecha'])  . '</h2>';

            $mensaje .= '<h3 style="text-align:center">'. esc_html($horo_ext[$signo . '-titulo']). '</h3>';
            $mensaje .= '<center><img src="'. esc_html($horo_ext[$signo . '-imagen']) . '" alt="Girl in a jacket" width="500" height="500" style="border-radius: 50%"></center>';
            $mensaje .= '<p>'. esc_html($horo_ext[$signo . '-texto'])  . '</p>';
            $mensaje .= '<h3 style="text-align:center">'. ucfirst($signo) . ' ' . $arraywords[0] . '</h3>';
            $mensaje .= '<p>'. esc_html($horo_ext[$signo . '-trabajo']) . '</p>';
            $mensaje .= '<h3 style="text-align:center">'. ucfirst($signo) . ' ' . $arraywords[1] . '</h3>';
            $mensaje .= '<p>'. esc_html($horo_ext[$signo . '-amor']) . '</p>';
            $mensaje .= '<h3 style="text-align:center">'. ucfirst($signo) . ' ' . $arraywords[2] . '</h3>';
            $mensaje .= '<p>'. esc_html($horo_ext[$signo . '-salud']) . '</p>';


            $mensaje .= '<p style="text-align:center" ><a href="' . $arraywords[5] . '" style="font-size:16px">' . $arraywords[4] . '</a></p>';

        }        

        

    } else {
        $mensaje = 'Error en Signo!';
    }   


    return $mensaje;

}

add_shortcode('la_horoscopo', 'lalwr_mostrarlahoro');

function shortcode_atts1( $pairs, $atts, $shortcode = '' ) {
	$atts = (array) $atts;

	$out  = array();
	foreach ( $pairs as $name => $default ) {

		if ( array_key_exists( $name, $atts ) ) {
			$out[ $name ] = $atts[ $name ];
		} else {
			$out[ $name ] = $default;
		}
	}

	if ( $shortcode ) {
		$out = apply_filters( "shortcode_atts_{$shortcode}", $out, $pairs, $atts, $shortcode );
	}

	return $out;
}


